theme_bwb = function (base_size = 11, base_family = "") {
  theme_bw(base_size = base_size, base_family = base_family) %+replace% 
    theme(panel.border = element_blank(), panel.grid.major = element_blank(), 
          panel.grid.minor = element_blank(), axis.line = element_line(colour = "black", size = 0.5), 
          legend.key = element_blank(), strip.background = element_rect(fill = "white", colour = "black", size = 1), complete = TRUE)
}


theme_bwb_highres = function (base_size = 30, # Set to large font size
                              base_family = "", 
                              legend.key.size = unit(1.7, 'lines') # Ensure distance between legend items is large enough
                              ) {
  theme_bw(base_size = base_size, base_family = base_family) %+replace% 
    theme(panel.border = element_blank(), panel.grid.major = element_blank(), 
          panel.grid.minor = element_blank(), axis.line = element_line(colour = "black", size = 0.5), 
          legend.key = element_blank(), legend.key.size = legend.key.size, strip.background = element_rect(fill = "white", colour = "black", size = 1), complete = TRUE)
}




theme_bwb_map = function (base_size = 11, base_family = "") 
{
  theme_bw(base_size = base_size, base_family = base_family) %+replace% 
    theme(panel.border = element_blank(), 
          panel.grid.major = element_line(colour = "grey92", size = 0.5), #element_blank(), 
          panel.grid.minor = element_blank(), 
          axis.line = element_blank(),#element_line(colour = "black", size = 0.5), 
          legend.key = element_blank(), 
          strip.background = element_rect(fill = "white", colour = "black", size = 1), 
          complete = TRUE
    )
  
}


