# Adapted from Ben Cooper (19/02/2018)
# 
# Adapted by BW Berkhout
# Last edit 31/03/2018
#
####################################################

## Function to load all required packages in script at once
## Also installs and then loads missing packages
## Works by feeding it a list of required packages

pRequire <- function(package.list)
  {
  for(i in 1:length(package.list))
    {
    ## Load package
    if(!require(package.list[i], quietly = TRUE, character.only = TRUE))
      {
      ## If package loading fails install package and load it
      install.packages(package.list[i])
      require(package.list[i], character.only = TRUE)
      }
    }
  }